//---------------------------------
// 2020/12/5

#ifndef WEB_PAGE_HANDLER_H
#define WEB_PAGE_HANDLER_H

#include <Arduino.h>
#include <WiFi.h>
#include <functional>
#include <esp_http_server.h>

class WebPageHandler{

public:
  static httpd_handle_t server;
  static const char pageBattery[];
  static const char pageLogFile[];
  static const char pageSystem[];
  static const char pageDownload[];
  static const httpd_uri_t uriBattery;
  static const httpd_uri_t uriLogFile;
  static const httpd_uri_t uriSystem;
  static const httpd_uri_t uriDownload;
  static std::function<void(uint8_t)> callBack;

  static const uint8_t idSleepControlOneTime = 9;

  // Functions
  static String getReqArg(httpd_req_t *req, String arg);
  static void startServer(std::function<void(uint8_t)> f);
  static String getHeader();
  static String getNavBar(const char*page);
  static String getScript();
  static esp_err_t handleBatteryPage(httpd_req_t *req);
  static esp_err_t handleLogFilePage(httpd_req_t *req);
  static esp_err_t handleSystemPage(httpd_req_t *req);
  static esp_err_t handleDownload(httpd_req_t *req);
  static void downloadFile(httpd_req_t *req, String path);

};

#endif


