//---------------------------------
// 2020/8/1

#ifndef TIMELY_TASK_MANAGER_H
#define TIMELY_TASK_MANAGER_H

#include <Arduino.h>
#include <WiFi.h>

class TimelyTaskManager {
 private:
  static const uint8_t taskNotSet = 0;
  static const uint8_t taskDaily = 1;
  static const uint8_t taskHourly = 2;
  static const uint8_t taskMinutely = 3;
  static const uint8_t taskSecondly = 4;
  static const uint8_t taskOneTime = 5;

  class Task {
   public:
    uint8_t set = taskNotSet;
    uint8_t lastUpdateDay = 0;
    uint8_t lastUpdateHour = 0;
    uint8_t lastUpdateMinute = 0;
    uint8_t lastUpdateSecond = 0;
    uint8_t hour = 0;
    uint8_t minute = 0;
    uint8_t second = 0;
    std::function<void()> task;
  };

  Task* taskList;
  uint8_t taskNum = 0;

 public:
  bool timeSource = true;
  static const uint8_t formatDay = 0;
  static const uint8_t formatMinute = 1;
  static const uint8_t formatSecond = 2;

  class StandaloneTime {
   public:
    uint32_t year = 0;
    uint32_t month = 0;
    uint32_t day = 0;
    uint32_t hour = 0;
    uint32_t minute = 0;
    uint32_t second = 0;
  };

  TimelyTaskManager(uint8_t n);
  ~TimelyTaskManager();
  void setTimeZone(long offset, int daylight);
  void config();
  void setDailyTask(uint8_t id, uint8_t setHour, uint8_t setMinute, std::function<void()> task);
  void setHourlyTask(uint8_t id, uint8_t setMinute, std::function<void()> task);
  void setMinutelyTask(uint8_t id, uint8_t setSecond, std::function<void()> task);
  void setSecondlyTask(uint8_t id, uint8_t interval, std::function<void()> task);
  void setOneTimeTask(uint8_t id, std::function<void()> task);
  void removeTask(uint8_t id);
  void updateTask();
  bool getSaTime(StandaloneTime* satime);
  String getTimeStr();
  String getTimeStr(uint8_t format);
  String getTimeFileName(uint8_t format);
};

#endif
