//---------------------------------
// 2017/1/27

#ifndef STRLIST_H
#define STRLIST_H

#include "Arduino.h"

// String list item
//  Store string and pointer to the next item
class StrListItem{
public:
  String str;
  StrListItem*next = NULL;
};


class StrList{
private:
  StrListItem*head = NULL;
  StrListItem*getItem = NULL;

public:
  ~StrList(){
    clear();
  }
  
  void add(String str){
    StrListItem*newItem = new StrListItem;
    newItem->str = str;

    // No item
    if(head==NULL){
      head = newItem;
      newItem->next = newItem;
      return;
    }
    // Insert to 1st
    if(newItem->str < head->str){
      newItem->next = head;
      head = newItem;
      return;
    }
    StrListItem*prev = head;
    StrListItem*item = head->next;
    while(1){
      // Reach end of the list
      if(prev==item){
        prev->next = newItem;
        newItem->next = newItem;
        return;
      }

      if(newItem->str < item->str){
        newItem->next = prev->next;
        prev->next = newItem;
        return;
      }

      prev = item;
      item = item->next;
    }
  }

  StrListItem*getFirst(){
    if(head==NULL){
      return NULL;
    }
    getItem = head;
    return head;
  }

  StrListItem*getNext(){
    if(getItem==NULL){
      return NULL;
    }

    // No more item
    if(getItem->next == getItem){
      return NULL;
    }
    getItem = getItem->next;
    return getItem;
  }

  StrListItem*getLast(){
    StrListItem*item = getFirst();
    if(item == NULL){
      return NULL;
    }

    uint32_t c = count();
    for(uint32_t i=1; i<c; i++){
      item = getNext();
    }
    return item;
  }

  bool remove(uint32_t index){
    uint32_t c = count();

    // Out of range
    if(c==0 || c<=index){
      return false;
    }

    StrListItem*item;
    
    if(index==0){
      if(c==1){
        delete head;
        head = NULL;
      }else{
        item = head;
        head = head->next;
        delete item;
      }
      return true;
    }

    StrListItem*prev = head;
    item = head->next;
    for(uint32_t i=1; i<index; i++){
      prev = item;
      item = item->next;
    }

    // Last item
    if(item->next == item){
      prev->next = prev;
      delete item;
    }else{
      prev->next = item->next;
      delete item;
    }
    return true;
  }

  void clear(){
    while(remove(0)){;}
  }
  
  uint32_t count(){
    if(head==NULL){
      return 0;
    }
    StrListItem*item = head;
    uint32_t n=1;
    while(1){
      if(item->next == item){
        return n;
      }
      item = item->next;
      n++;
    }
  }

  void printList(){
    Serial.println("----------------");
    StrListItem*item = getFirst();
    while(item!=NULL){
      Serial.println(item->str);
      item = getNext();
    }
    Serial.println("----------------");
  }
};




#endif


