//---------------------------------
// 2020/12/5

#ifndef STORAGE_H
#define STORAGE_H

#include <Arduino.h>
#include <SD.h>
#include <SPIFFS.h>

class Storage {
 public:
  static const bool opLogSerial = true;   // シリアルモニターに動作ログを表示
  static const bool opLogStorage = true;  // ストレージ(SDかSPIFFS)に動作ログを記録
  static const bool opLogSD = true;       // true : SD, false : SPIFFS
  static const String opLogDir;
  static const String opLogFileName;
  static const uint8_t pinSDCS = 17;  // SD SPI CS Pin

  static void opLog(String logStr);
  static String getOpLogPath();
  static File open(String path, const char* mode);
  static void end();
  static void remove(String path);
  static bool exists(String path);
  static void mkdir(String path);
};

#endif
