//---------------------------------
// 2020/12/5

#include "Storage.h"

const String Storage::opLogDir = "/";
const String Storage::opLogFileName = "op.log";

void Storage::opLog(String logStr) {
  if (opLogSerial) {
    Serial.print(logStr);
  }

  if (!opLogStorage) {
    return;
  }

  if (!exists(opLogDir)) {
    Storage::mkdir(opLogDir);
  }

  String path;
  path = getOpLogPath();
  File file = open(path, FILE_APPEND);
  if (file) {
    file.print(logStr.c_str());
    file.close();
  }
  end();
}

String Storage::getOpLogPath() {
  if (opLogDir.endsWith("/")) {
    return opLogDir + opLogFileName;
  } else {
    return opLogDir + "/" + opLogFileName;
  }
}

File Storage::open(String path, const char* mode) {
  if (!path.startsWith("/")) {
    path = "/" + path;
  }
  if (opLogSD) {
    SD.begin(pinSDCS);  // Some card rquires
    if (SD.begin(pinSDCS)) {
      return SD.open(path, mode);
    }
  } else {
    if (SPIFFS.begin(true)) {
      return SPIFFS.open(path, mode);
    }
  }
  return File();
}

void Storage::end() {
  if (opLogSD) {
    // SD.end();  // Do not use end fucntion. Memory leak issue on esp32 core 1.0.4. 
  } else {
    SPIFFS.end();
  }
}

void Storage::remove(String path) {
  if (opLogSD) {
    SD.begin(pinSDCS);  // Some card rquires
    if (SD.begin(pinSDCS)) {
      SD.remove(path);
    }
  } else {
    if (SPIFFS.begin(true)) {
      SPIFFS.remove(path);
    }
  }
}

bool Storage::exists(String path) {
  bool r = false;
  if (opLogSD) {
    SD.begin(pinSDCS);  // Some card rquires
    if (SD.begin(pinSDCS)) {
      r = SD.exists(path);
    }
  } else {
    if (SPIFFS.begin(true)) {
      r = SPIFFS.exists(path);
    }
  }
  return r;
}

void Storage::mkdir(String path) {
  if (opLogSD) {
    SD.begin(pinSDCS);  // Some card rquires
    if (SD.begin(pinSDCS)) {
      SD.mkdir(path);
    }
  } else {
    if (SPIFFS.begin(true)) {
      SPIFFS.mkdir(path);
    }
  }
}
