//---------------------------------
// 2020/8/1

#ifndef LCDAQM_H
#define LCDAQM_H

#include <Wire.h>

class LCDAQM {
 private:
  static const uint8_t i2cAddr = 0x3E;

  // I2C Pin
  uint8_t pinSCL;
  uint8_t pinSDA;

  uint8_t count;  // Character count in line
  uint8_t line;   // 1:1st line, 2:2nd line

 public:
  LCDAQM(uint8_t sda, uint8_t scl);
  void writeData(uint8_t ctrl, uint8_t data);
  uint8_t init();
  void printStr(const char* str);
  void clear();
  void home();
  void secLine();
};

#endif
