//---------------------------------
// 2020/8/1

#include "LCDAQM.h"

LCDAQM::LCDAQM(uint8_t sda, uint8_t scl) {
  pinSDA = sda;
  pinSCL = scl;
  count = 0;
  line = 1;
}

// Initialize LCD
//  Return 0 if success
uint8_t LCDAQM::init() {
  writeData(0, 0x38);
  writeData(0, 0x39);
  writeData(0, 0x14);
  writeData(0, 0x7A);
  writeData(0, 0x55);
  writeData(0, 0x6C);
  delay(250);
  writeData(0, 0x38);
  writeData(0, 0x0C);
  clear();

  return 0;
}

// Write control and data by I2C
void LCDAQM::writeData(uint8_t ctrl, uint8_t data) {
  Wire.begin(pinSDA, pinSCL);
  Wire.beginTransmission(i2cAddr);
  Wire.write(ctrl);
  Wire.write(data);
  Wire.endTransmission();
  delayMicroseconds(50);
  return;
}

void LCDAQM::printStr(const char* str) {
  for (uint8_t i = 0; i < 16; i++) {
    // Null character
    if (str[i] == 0) {
      return;
    }
    count++;
    if (count > 8) {
      if (line == 2) {
        home();
      } else {
        secLine();
      }
    }
    writeData(0x40, str[i]);
  }
}

void LCDAQM::clear() {
  count = 0;
  line = 1;
  writeData(0, 0x01);
  delay(2);
}

void LCDAQM::home() {
  count = 0;
  line = 1;
  writeData(0, 0x02);
  delay(2);
}

void LCDAQM::secLine() {
  count = 0;
  line = 2;
  writeData(0, 0xC0);
}
