//---------------------------------
// 2020/9/21

#ifndef INA219I2C_H
#define INA219I2C_H

#include <Arduino.h>
#include <Wire.h>

class INA219I2C {
 private:
  // I2C Pin
  uint8_t pinSCL;
  uint8_t pinSDA;

  // R=100m, +/-3.2A range, LSB 0.1mA
  // uint16_t cal = 4096;
  // float currentLSB = 0.1F;  // mA
  // float powerLSB = 2.0F;    // mW

  // R=10m, +/-32A range, LSB 1mA
  uint16_t cal = 4096;
  float currentLSB = 1.0F;  // A
  float powerLSB = 0.2F;    // 1/10 W

  // Store measured value
  float lastVbus = 0;
  float lastCurrent = 0;
  float lastPower = 0;

 public:
  static const uint8_t i2cAddr = 0x40;

  INA219I2C(uint8_t sda, uint8_t scl);
  uint16_t readAddress(uint8_t addr);
  void writeAddress(uint8_t addr, uint16_t data);
  bool init();
  float vbus(bool meas = true);
  String vbusStr(bool meas = true);
  float current(bool meas = true);
  String currentStr(bool meas = true);
  float power(bool meas = true);
  String powerStr(bool meas = true);
};

#endif
